using System;
using System.Text;
using Borland.Eco.Ocl.Support;

namespace CustomOclOperations
{
	/// <summary>
	/// This operation reverses the string parameter.
	/// </summary>
	public class ReverseStringOclOp: OclOperationBase
	{
		public override void Evaluate(IOclOperationParameters parameters)
		{
			// first extract the value of the 0th parameter
			string orgstring = Support.GetAsString(parameters.Values[0]);
			// then reverse it, store the result in a stringbuilder
			StringBuilder sb = new StringBuilder(orgstring.Length);
			for (int i = 0; i < orgstring.Length; i++)
				sb.Append(orgstring[orgstring.Length - i - 1]);
			// finally, store the reversed string as the value of the result-node 
			Support.MakeNewString(parameters.Result, sb.ToString());
		}
		protected override void Init()
		{
			// the name of the operation is reverseString
			// there is only one parameter (the 0th parameter, and its type is string
			// the result is a string
			InternalInit("reverseString", new IOclType[]{Support.StringType}, Support.StringType);
		}
	}
}
